local t = Def.ActorFrame {
	-- Def.Quad {
		-- Name="HeaderUnderBase",
		-- InitCommand=cmd(rotationz,-0.75;horizalign,left;vertalign,bottom;xy,-20,38;zoomto,_screen.w*1.3,80;diffuse,LocalBlueColor(0.5))
	-- },
	-- Def.Quad {
		-- Name="HeaderBase",
		-- InitCommand=cmd(horizalign,left;vertalign,bottom;xy,-20,20;zoomto,_screen.w*1.3,80;diffuse,LocalBlueColor(1))
	-- },
	
	LoadActor(THEME:GetPathG("", "_ScreenSelectMusic header")) .. {
		InitCommand=cmd(horizalign,right;vertalign,top;xy,_screen.w,-45;rotationz,-3)
	},
	
	-- Lower layer of header text...
	LoadFont("Common Large") .. {
		Name="HeaderText",
		Text=string.upper(Screen.String("HeaderText")),
		InitCommand=cmd(xy,_screen.w-14,10;horizalign,right;vertalign,bottom;shadowlength,2;maxwidth,(_screen.w/3)/1.35;zoom,1.35),
		OnCommand=cmd(diffuse,LocalBlueColor(0.3);strokecolor,LocalBlueColor(0.3)),
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header):uppercase(true)
		end
	},
	
	-- ...and the upper layer of it.
	LoadFont("Common Normal") .. {
		Name="HeaderText",
		Text=string.upper(Screen.String("HeaderText")),
		InitCommand=cmd(xy,_screen.w-14,10;horizalign,right;vertalign,bottom;shadowlength,2;maxwidth,(_screen.w/3)/1.1;zoom,1.1),
		OnCommand=cmd(strokecolor,LocalBlueColor(0)),
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header):uppercase(true)
		end
	},
	
	Def.BitmapText {
		Name = "ModeDisplay",
		Font = "Common Normal",
		Text = CurGameModeString(),
		InitCommand=cmd(xy,_screen.cx/1.7,10;horizalign,left;vertalign,bottom;strokecolor,Color.Black;zoom,0.6;draworder,1;uppercase,true)
	}
}

if not GAMESTATE:IsCourseMode() then
	t[#t+1] = Def.BitmapText {
		Name = "StageDisplay",
		Font = "Common Normal",
		InitCommand=cmd(xy,_screen.w-14,18;horizalign,right;vertalign,top;strokecolor,LocalBlueColor(0);zoom,0.6),
		OnCommand=function(self)
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1
			local curStage = GAMESTATE:GetCurrentStage()
			if GAMESTATE:IsEventMode() then
				self:settextf("Stage %s", curStageIndex)
			else
				self:settext(StageToLocalizedString(GAMESTATE:GetCurrentStage()))
			end
			
			--self:diffuse(StageToColor(GAMESTATE:GetCurrentStage()))
			--SM(LocalBlueColor(0.25))
		end
	}
end

return t
